﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using BMS.Facade.Data;
using BMS.Web.App_GlobalResource;
using BMS.Web.Models.Shared;
using BMS.Web.Controllers.Shared;
using System.ComponentModel.DataAnnotations;

namespace BMS.Web.Models
{
    /// <summary>
    /// Add/Edit Sister Site Model class.
    /// </summary>
    public class AdminSisterSiteAddEditViewModel : BaseViewModel
    {
        /// <summary>
        /// A list of all sister sites groups.
        /// </summary>
        public List<SisterSiteGroupViewModel> SisterSitesGroups { get; set; }

        [Required(ErrorMessage = "The Record No is required!")]
        [Range(1, 100000000000, ErrorMessage = "Please enter a value greater than 0")]
        public int? RecordNumber { get; set; }

        [ValidateXss]
        public string SisterSiteCodes { get; set; }

        /// <summary>
        /// The id of the current sister sites group.
        /// </summary>
        public int SisterSiteNumber { get; set; }

        /// <summary>
        /// Gets or sets the message for sister site edit saved.
        /// </summary>
        /// <value>
        /// The message for sister site edit saved.
        /// </value>
        public string MessageForSisterSiteEditSaved { get; set; }

        /// <summary>
        /// Gets or sets the codes do not exist in data base.
        /// </summary>
        /// <value>
        /// The codes do not exist in data base.
        /// </value>
        public string CodesDoNotExistInDataBase { get; set; }

        /// <summary>
        /// Gets or sets the BTN select sister site.
        /// </summary>
        /// <value>
        /// The BTN select sister site.
        /// </value>
        public string BtnSelectSisterSite { get; set; }

    }
}